#ifndef QPSXSERIAL_H
#define QPSXSERIAL_H

#include <QMainWindow>
#include <QtSerialPort/QSerialPort>
#include <QString>
#include <QDebug>
#include <QTimer>
#include <QThread>
#include <QTime>
#ifdef __WIN32__
#include <QWinTaskbarButton>
#endif
#include <QMessageBox>
#include <iostream>
#include "ui_stdout.h"

#define QPSXSERIAL_VERSION_STR      "0.5"
#define QPSXSERIAL_URL              "https://github.com/XaviDCR92/OpenSend"
#define OPENSEND_URL                "https://github.com/XaviDCR92/QPSXSerial/"

typedef enum
{
    CLI_APP,
    GUI_APP
}APP_INTERFACE;

namespace Ui {
class QPSXSerial;
}

class QPSXSerial : public QMainWindow
{
    Q_OBJECT

public:
    explicit QPSXSerial(QWidget *parent = nullptr, APP_INTERFACE interface = GUI_APP);
    ~QPSXSerial();
    void setParamList(QStringList param){_paramlist = param;}

private:
    bool            sendExe(void);
    void            sendData(QByteArray data, QString fileName);
    void            sendDataSize(quint32 size);
    void            showError(QString error);
    void            showHelp(void);
    QString         getInputExeFromFolder(QString *folder);
    void            showGUICLIerror(QString error);

    Ui::QPSXSerial      *ui;
    Ui::Stdout_Console  *stdout_ui;
    QDialog             *stdout_dialog;
    const APP_INTERFACE app_interface;
    QString             inputExe;
    QString             selectedPort;
    QString             selectedFolder;
    QSerialPort         serial;
    bool                ack;
    bool                exe_sent;
    QTimer              init_timer;
    bool                write_ready;
    bool                byte_sent_received;
    QByteArray          last_packet_sent;
    bool                first_entered;
    QTimer              lost_packet_timer;
    QStringList         _paramlist;
    bool                disable_psx_stdout;

public slots:
    void cli_run(void);

private slots:
    void onLoadFileBtnReleased(void);
    void onUpdatePortsBtnReleased(void);
    void onSendBtnReleased(void);
    void onPortSelectedComboBox(QString);
    void onBytesWritten(qint64);
    void onReadyRead(void);
    void connectToPSXTimeout(void);
    void onPacketLost(void);
    void onStdOutButtonReleased(void);

signals:
    void debug_frame_received(QString);
    void finished(void);
};

#endif // QPSXSERIAL_H
