/*
 * Decompiled with CFR 0.152.
 */
package psx;

import docking.widgets.OptionDialog;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.ApplyFunctionDataTypesCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.datamgr.archive.DuplicateIdException;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.store.LockException;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import psx.PsxBaseChooser;
import psx.PsxExe;
import psyq.DetectPsyQ;

public class PsxLoader
extends AbstractLibrarySupportLoader {
    public static final String PSYQ_VER_OPTION = "PsyQ Version";
    private static final long DEF_RAM_BASE = 0x80000000L;
    public static final long RAM_SIZE = 0x200000L;
    private static final long __heapbase_off = -48L;
    private static final long _sbss_off = -40L;
    private static final long _sdata_off = -32L;
    private static final byte[] MAIN_SIGN_47 = new byte[]{0, 0, 0, 12, 0, 0, 0, 0, 1, 0, 4, 60, 0, 0, 0, 0, 1, 0, 5, 60, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 77, 0, 0, 0};
    private static final byte[] MAIN_SIGN_MASK_47 = new byte[]{0, 0, 0, -1, -1, -1, -1, -1, -1, 0, -1, -1, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final byte[] MAIN_SIGN_37_46 = new byte[]{0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 77, 0, 0, 0};
    private static final byte[] MAIN_SIGN_MASK_37_46 = new byte[]{-1, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final String PSX_LOADER = "PSX Executables Loader";
    private PsxExe psxExe;
    private static final String OPTION_NAME = "RAM Base Address: ";
    public static long ramBase = 0x80000000L;

    public String getName() {
        return PSX_LOADER;
    }

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        BinaryReader reader = new BinaryReader(provider, true);
        this.psxExe = new PsxExe(reader);
        if (this.psxExe.isParsed()) {
            loadSpecs.add(new LoadSpec((Loader)this, 0L, new LanguageCompilerSpecPair("MIPS:LE:32:default", "default"), true));
        }
        return loadSpecs;
    }

    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        ArrayList<Option> list = new ArrayList<Option>();
        list.add(new PsxBaseChooser(OPTION_NAME, ramBase, PsxBaseChooser.class, "-loader-ramStart"));
        return list;
    }

    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        for (Option option : options) {
            String optName = option.getName();
            if (!optName.equals(OPTION_NAME)) continue;
            ramBase = Long.decode((String)option.getValue());
            break;
        }
        return null;
    }

    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException {
        if (!this.psxExe.isParsed()) {
            monitor.setMessage(String.format("%s : Cannot load", this.getName()));
            return;
        }
        monitor.setMessage("Loading PSX binary...");
        FlatProgramAPI fpa = new FlatProgramAPI(program, monitor);
        long realRamBase = this.psxExe.getInitPc() & 0xFF000000L;
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (realRamBase != ramBase) {
            if (ramBase == 0x80000000L) {
                ramBase = realRamBase;
            } else {
                switch (OptionDialog.showYesNoDialogWithNoAsDefaultButton(null, (String)"Question", (String)("RAM Base Address in the \"PS-X EXE\" header differs from the specified one!\n\nDo you want to continue?\n" + String.format("YES: Use specified address           - 0x%08X.\n", ramBase) + String.format(" NO: Use address based on the binary - 0x%08X.\n", realRamBase)))) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ramBase = realRamBase;
                    }
                }
            }
        }
        try {
            program.setImageBase(fpa.toAddr(ramBase), true);
        }
        catch (LockException | AddressOverflowException | IllegalStateException e1) {
            log.appendException(e1);
            return;
        }
        this.createSegments(provider, fpa, log);
        PsxLoader.addPsyqVerOption(program, ramBase, log);
        PsxLoader.setFunction(program, fpa.toAddr(this.psxExe.getInitPc()), "start", true, true, log);
        PsxLoader.setRegisterValue(fpa, "gp", this.psxExe.getInitPc(), this.psxExe.getInitGp(), log);
        PsxLoader.setRegisterValue(fpa, "sp", this.psxExe.getInitPc(), this.psxExe.getSpBase() + this.psxExe.getSpOff(), log);
        Address romStart = fpa.toAddr(this.psxExe.getRomStart());
        Reference mainRef = PsxLoader.findAndAppyMain(provider, fpa, romStart, log);
        if (mainRef != null) {
            PsxLoader.createCompilerSegments(provider, fpa, romStart, mainRef, log);
        }
        monitor.setMessage("Loading PSX binary done.");
    }

    public static DataTypeManagerService getDataTypeManagerService(Program program) {
        return AutoAnalysisManager.getAnalysisManager((Program)program).getDataTypeManagerService();
    }

    private static void addPsyqVerOption(Program program, long searchBase, MessageLog log) {
        Memory mem = program.getMemory();
        try {
            String psyqVersion = DetectPsyQ.getPsyqVersion(mem, program.getAddressFactory().getDefaultAddressSpace().getAddress(searchBase));
            Options opts = program.getOptions("Program Information");
            opts.registerOption(PSYQ_VER_OPTION, (Object)"", null, "PsyQ version");
            if (!psyqVersion.isEmpty()) {
                String subVer = psyqVersion.substring(2);
                String ver = String.format("%s.%s%s", Character.valueOf(psyqVersion.charAt(0)), Character.valueOf(psyqVersion.charAt(1)), !subVer.equals("00") ? String.format(".%s", subVer) : "");
                opts.setString(PSYQ_VER_OPTION, ver);
            }
        }
        catch (AddressOutOfBoundsException | MemoryAccessException | IOException throwable) {
            // empty catch block
        }
    }

    public static DataTypeManager loadPsyqGdt(Program program, AddressSetView set) {
        String gdtName = String.format("psyq%s", PsxLoader.getProgramPsyqVersion(program));
        PsxLoader.closePsyqDataTypeArchives(program, gdtName);
        return PsxLoader.loadPsyqArchive(program, gdtName, set, TaskMonitor.DUMMY, new MessageLog());
    }

    private static void closePsyqDataTypeArchives(Program program, String gdtName) {
        DataTypeManager[] mgrs;
        DataTypeManagerService srv = PsxLoader.getDataTypeManagerService(program);
        for (DataTypeManager mgr : mgrs = srv.getDataTypeManagers()) {
            if (mgr.getName().contains(gdtName)) continue;
            srv.closeArchive(mgr);
        }
    }

    private static DataTypeManager loadPsyqArchive(Program program, String gdtName, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        DataTypeManagerService srv = PsxLoader.getDataTypeManagerService(program);
        if (gdtName.isEmpty()) {
            return null;
        }
        try {
            DataTypeManager[] mgrs;
            for (DataTypeManager mgr : mgrs = srv.getDataTypeManagers()) {
                if (!mgr.getName().equals(gdtName)) continue;
                PsxLoader.applyDataTypes(program, set, mgr, monitor);
                return mgr;
            }
            DataTypeManager mgr = srv.openDataTypeArchive(gdtName);
            if (mgr == null) {
                throw new IOException(String.format("Cannot find \"%s\" data type archive!", gdtName));
            }
            if (set != null) {
                PsxLoader.applyDataTypes(program, set, mgr, monitor);
            }
            return mgr;
        }
        catch (DuplicateIdException | IOException e) {
            log.appendException(e);
            return null;
        }
    }

    private static void applyDataTypes(Program program, AddressSetView set, DataTypeManager mgr, TaskMonitor monitor) {
        int transId = program.startTransaction("Apply function data types");
        ArrayList<DataTypeManager> gdtList = new ArrayList<DataTypeManager>();
        gdtList.add(mgr);
        ApplyFunctionDataTypesCmd cmd = new ApplyFunctionDataTypesCmd(gdtList, set, SourceType.ANALYSIS, true, false);
        cmd.applyTo((DomainObject)program, monitor);
        program.endTransaction(transId, true);
    }

    public static String getProgramPsyqVersion(Program program) {
        Options opts = program.getOptions("Program Information");
        return opts.getString(PSYQ_VER_OPTION, "").replace(".", "");
    }

    public static void setProgramPsyqVersion(Program program, String newVersion) {
        Options opts = program.getOptions("Program Information");
        opts.setString(PSYQ_VER_OPTION, newVersion.replace(".", ""));
    }

    private static void setRegisterValue(FlatProgramAPI fpa, String name, long startAddress, long value, MessageLog log) {
        Program program = fpa.getCurrentProgram();
        RegisterValue regVal = new RegisterValue(program.getRegister(name), BigInteger.valueOf(value));
        Address start = fpa.toAddr(startAddress);
        try {
            program.getProgramContext().setRegisterValue(start, start, regVal);
        }
        catch (ContextChangeException e) {
            log.appendException((Throwable)e);
        }
    }

    private static void disasmInstruction(Program program, Address address) {
        DisassembleCommand cmd = new DisassembleCommand(address, null, true);
        cmd.applyTo((DomainObject)program, TaskMonitor.DUMMY);
    }

    public static void setFunction(Program program, Address address, String name, boolean isFunction, boolean isEntryPoint, MessageLog log) {
        try {
            SymbolTable st = program.getSymbolTable();
            if (program.getListing().getInstructionAt(address) == null) {
                PsxLoader.disasmInstruction(program, address);
            }
            if (isFunction) {
                CreateFunctionCmd cmd = new CreateFunctionCmd(name, address, null, SourceType.USER_DEFINED);
                cmd.applyTo((DomainObject)program, TaskMonitor.DUMMY);
            }
            if (isEntryPoint) {
                st.addExternalEntryPoint(address);
            }
            if (isFunction && st.hasSymbol(address)) {
                return;
            }
            st.createLabel(address, name, SourceType.ANALYSIS);
        }
        catch (InvalidInputException e) {
            log.appendException((Throwable)e);
        }
    }

    private static Reference findAndAppyMain(ByteProvider provider, FlatProgramAPI fpa, Address searchAddress, MessageLog log) {
        Reference[] jalMainRefs;
        Instruction jalMain;
        Program program = fpa.getCurrentProgram();
        Memory mem = program.getMemory();
        Listing listing = program.getListing();
        SymbolTable st = program.getSymbolTable();
        Address mainRefAddr = mem.findBytes(searchAddress, MAIN_SIGN_47, MAIN_SIGN_MASK_47, true, TaskMonitor.DUMMY);
        if (mainRefAddr == null) {
            mainRefAddr = program.getMemory().findBytes(searchAddress, MAIN_SIGN_37_46, MAIN_SIGN_MASK_37_46, true, TaskMonitor.DUMMY);
            if (mainRefAddr == null) {
                return null;
            }
            mainRefAddr = mainRefAddr.add(4L);
        }
        if ((jalMain = listing.getInstructionAt(mainRefAddr)) == null) {
            PsxLoader.disasmInstruction(program, mainRefAddr);
            jalMain = listing.getInstructionAt(mainRefAddr);
            if (jalMain == null) {
                return null;
            }
        }
        if ((jalMainRefs = jalMain.getReferencesFrom()).length != 1) {
            return null;
        }
        Address mainAddr = jalMainRefs[0].getToAddress();
        try {
            st.createLabel(mainAddr, "main", SourceType.USER_DEFINED);
        }
        catch (InvalidInputException e) {
            log.appendException((Throwable)e);
            return null;
        }
        return jalMainRefs[0];
    }

    private static void createCompilerSegments(ByteProvider provider, FlatProgramAPI fpa, Address searchAddress, Reference mainRef, MessageLog log) {
        Program program = fpa.getCurrentProgram();
        Memory mem = program.getMemory();
        Listing listing = program.getListing();
        BinaryReader reader = new BinaryReader(provider, true);
        Address mainRefAddr = mainRef.getFromAddress();
        Instruction heapBaseInstr_1 = listing.getInstructionAt(mainRefAddr.add(-48L));
        Instruction heapBaseInstr_2 = listing.getInstructionAt(mainRefAddr.add(-48L).add(4L));
        Instruction sbssInstr1 = listing.getInstructionAt(mainRefAddr.add(-40L));
        Instruction sbssInstr2 = listing.getInstructionAt(mainRefAddr.add(-40L).add(4L));
        Instruction sdataInstr1 = listing.getInstructionAt(mainRefAddr.add(-32L));
        Instruction sdataInstr2 = listing.getInstructionAt(mainRefAddr.add(-32L).add(4L));
        if (heapBaseInstr_1 == null || heapBaseInstr_2 == null || sbssInstr1 == null || sbssInstr2 == null || sdataInstr1 == null || sdataInstr2 == null) {
            return;
        }
        Scalar heapBase1 = heapBaseInstr_1.getScalar(1);
        Object[] heapBase2 = heapBaseInstr_2.getOpObjects(1);
        Scalar sbss1 = sbssInstr1.getScalar(1);
        Object[] sbss2 = sbssInstr2.getOpObjects(1);
        Scalar sdata1 = sdataInstr1.getScalar(1);
        Scalar sdata2 = sdataInstr2.getScalar(2);
        if (heapBase1 == null || heapBase2 == null || heapBase2.length != 2 || sbss1 == null || sbss2 == null || sbss2.length != 2 || sdata1 == null || sdata2 == null) {
            return;
        }
        try {
            MemoryBlock _rdata_block;
            Address _rdata_addr;
            Address structPtr = fpa.toAddr((heapBase1.getUnsignedValue() << 16) + ((Scalar)heapBase2[0]).getSignedValue());
            Address _text_ptr = structPtr.add(8L);
            long _text = reader.readUnsignedInt(_text_ptr.subtract(searchAddress.subtract(2048L)));
            long _textlen = reader.readUnsignedInt(_text_ptr.add(4L).subtract(searchAddress.subtract(2048L)));
            _textlen = _textlen == 0L ? 4L : _textlen;
            Address _text_addr = fpa.toAddr(_text);
            MemoryBlock _text_block = mem.getBlock(_text_addr);
            boolean normalOrder = false;
            if (_text_block.getStart().getOffset() < _text_addr.getOffset()) {
                mem.split(_text_block, _text_addr);
                normalOrder = true;
            }
            if (normalOrder) {
                _rdata_addr = _text_block.getStart();
                _rdata_block = mem.getBlock(_rdata_addr);
                _rdata_block.setName(".rdata");
                _rdata_block.setWrite(false);
                _rdata_block.setExecute(false);
                _text_block = mem.getBlock(_text_addr);
                _text_block.setName(".text");
                _text_block.setWrite(false);
                _text_block.setExecute(true);
                mem.split(_text_block, _text_addr.add(_textlen));
            } else {
                _rdata_addr = _text_addr.add(_textlen);
                _text_block = mem.getBlock(_text_addr);
                _text_block.setName(".text");
                _text_block.setWrite(false);
                _text_block.setExecute(true);
                mem.split(_text_block, _rdata_addr);
                _rdata_block = mem.getBlock(_rdata_addr);
                _rdata_block.setName(".rdata");
                _rdata_block.setWrite(false);
                _rdata_block.setExecute(false);
            }
            Address _data_ptr = structPtr.add(16L);
            long _data = reader.readUnsignedInt(_data_ptr.subtract(searchAddress.subtract(2048L)));
            long _datalen = reader.readUnsignedInt(_data_ptr.add(4L).subtract(searchAddress.subtract(2048L)));
            _datalen = _datalen == 0L ? 4L : _datalen;
            Address _data_addr = fpa.toAddr(_data);
            MemoryBlock _data_block = mem.getBlock(_data_addr);
            if (_data_block.getStart().getOffset() < _data_addr.getOffset()) {
                mem.split(_data_block, _data_addr);
                _data_block = mem.getBlock(_data_addr);
            }
            _data_block.setName(".data");
            _data_block.setWrite(true);
            _data_block.setExecute(false);
            if (_data_block.getSize() > _datalen) {
                mem.split(_data_block, _data_addr.add(_datalen));
            }
            Address _sdata_addr = fpa.toAddr((sdata1.getUnsignedValue() << 16) + sdata2.getSignedValue());
            MemoryBlock _sdata_block = mem.getBlock(_sdata_addr);
            _sdata_block.setName(".sdata");
            _sdata_block.setWrite(true);
            _sdata_block.setExecute(false);
            PsxLoader.setRegisterValue(fpa, "gp", mainRef.getToAddress().getOffset(), _sdata_addr.getOffset(), log);
            Address _sbss_addr = fpa.toAddr((sbss1.getUnsignedValue() << 16) + ((Scalar)sbss2[0]).getSignedValue());
            MemoryBlock _sbss_block = mem.getBlock(_sbss_addr);
            if (_sbss_block.getStart().getOffset() < _sbss_addr.getOffset()) {
                mem.split(_sbss_block, _sbss_addr);
                _sbss_block = mem.getBlock(_sbss_addr);
                _sbss_block.setName(".sbss");
            }
            _sbss_block.setWrite(true);
            _sbss_block.setExecute(false);
            if (_sbss_block.isInitialized()) {
                mem.convertToUninitialized(_sbss_block);
            }
            Address _bss_ptr = structPtr.add(24L);
            long _bss = reader.readUnsignedInt(_bss_ptr.subtract(searchAddress.subtract(2048L)));
            long _bsslen = reader.readUnsignedInt(_bss_ptr.add(4L).subtract(searchAddress.subtract(2048L)));
            _bsslen = _bsslen == 0L ? 4L : _bsslen;
            Address _bss_addr = fpa.toAddr(_bss);
            MemoryBlock _bss_block = mem.getBlock(_bss_addr);
            mem.split(_bss_block, _bss_addr);
            _bss_block = mem.getBlock(_bss_addr);
            _bss_block.setName(".bss");
            _bss_block.setWrite(false);
            _bss_block.setExecute(false);
            if (_bss_block.isInitialized()) {
                mem.convertToUninitialized(_bss_block);
            }
            if (_bss_block.getSize() < _bsslen) {
                MemoryBlock block2 = mem.getBlock(_bss_addr.add(_bsslen));
                mem.join(_bss_block, block2);
                _bss_block = mem.getBlock(_bss_addr);
            }
            mem.split(_bss_block, _bss_addr.add(_bsslen));
            MemoryBlock ram = mem.getBlock(_bss_addr.add(_bsslen));
            ram.setName("RAM");
            ram.setWrite(true);
            ram.setExecute(true);
        }
        catch (LockException | MemoryBlockException | NotFoundException | IOException e) {
            log.appendException(e);
        }
    }

    private void createSegments(ByteProvider provider, FlatProgramAPI fpa, MessageLog log) throws IOException {
        InputStream codeStream = provider.getInputStream(2048L);
        long ram_size_1 = this.psxExe.getRomStart() - ramBase;
        PsxLoader.createSegment(fpa, null, "RAM", ramBase, ram_size_1, true, true, log);
        long code_size = this.psxExe.getRomSize();
        long code_addr = this.psxExe.getRomStart();
        PsxLoader.createSegment(fpa, codeStream, "CODE", code_addr, code_size, false, true, log);
        if (this.psxExe.getDataAddr() != 0L) {
            PsxLoader.createSegment(fpa, null, ".data", this.psxExe.getDataAddr(), this.psxExe.getDataSize(), true, false, log);
        }
        if (this.psxExe.getBssAddr() != 0L) {
            PsxLoader.createSegment(fpa, null, ".bss", this.psxExe.getBssAddr(), this.psxExe.getBssSize(), false, false, log);
        }
        long code_end = this.psxExe.getRomEnd();
        long ram_size_2 = ramBase + 0x200000L - code_end;
        PsxLoader.createSegment(fpa, null, "RAM", code_end, ram_size_2, false, true, log);
        PsxLoader.createSegment(fpa, null, "CACHE", 528482304L, 1024L, true, true, log);
        PsxLoader.createSegment(fpa, null, "UNK1", 528483328L, 3072L, true, true, log);
        PsxLoader.addMemCtrl1(fpa, log);
        PsxLoader.addMemCtrl2(fpa, log);
        PsxLoader.addPeriphIo(fpa, log);
        PsxLoader.addIntCtrl(fpa, log);
        PsxLoader.addDma(fpa, log);
        PsxLoader.addTimers(fpa, log);
        PsxLoader.addCdromRegs(fpa, log);
        PsxLoader.addGpuRegs(fpa, log);
        PsxLoader.addMdecRegs(fpa, log);
        PsxLoader.addSpuVoices(fpa, log);
        PsxLoader.addSpuCtrlRegs(fpa, log);
    }

    private static void addMemCtrl1(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "MCTRL1", 528486400L, 36L, true, false, log);
        PsxLoader.createNamedDword(fpa, 528486400L, "EXP1_BASE_ADDR", log);
        PsxLoader.createNamedDword(fpa, 528486404L, "EXP2_BASE_ADDR", log);
        PsxLoader.createNamedDword(fpa, 528486408L, "EXP1_DELAY_SIZE", log);
        PsxLoader.createNamedDword(fpa, 528486412L, "EXP3_DELAY_SIZE", log);
        PsxLoader.createNamedDword(fpa, 528486416L, "BIOS_ROM", log);
        PsxLoader.createNamedDword(fpa, 528486420L, "SPU_DELAY", log);
        PsxLoader.createNamedDword(fpa, 528486424L, "CDROM_DELAY", log);
        PsxLoader.createNamedDword(fpa, 528486428L, "EXP2_DELAY_SIZE", log);
        PsxLoader.createNamedDword(fpa, 528486432L, "COMMON_DELAY", log);
    }

    private static void addMemCtrl2(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "MCTRL2", 528486496L, 4L, true, false, log);
        PsxLoader.createNamedDword(fpa, 528486496L, "RAM_SIZE", log);
    }

    private static void addPeriphIo(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "IO_PORTS", 528486464L, 32L, true, false, log);
        PsxLoader.createNamedDword(fpa, 528486464L, "JOY_MCD_DATA", log);
        PsxLoader.createNamedDword(fpa, 528486468L, "JOY_MCD_STAT", log);
        PsxLoader.createNamedWord(fpa, 528486472L, "JOY_MCD_MODE", log);
        PsxLoader.createNamedWord(fpa, 528486474L, "JOY_MCD_CTRL", log);
        PsxLoader.createNamedWord(fpa, 528486478L, "JOY_MCD_BAUD", log);
        PsxLoader.createNamedDword(fpa, 528486480L, "SIO_DATA", log);
        PsxLoader.createNamedDword(fpa, 528486484L, "SIO_STAT", log);
        PsxLoader.createNamedWord(fpa, 528486488L, "SIO_MODE", log);
        PsxLoader.createNamedWord(fpa, 528486490L, "SIO_CTRL", log);
        PsxLoader.createNamedWord(fpa, 528486492L, "SIO_MISC", log);
        PsxLoader.createNamedWord(fpa, 528486494L, "SIO_BAUD", log);
    }

    private static void addIntCtrl(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "INT_CTRL", 528486512L, 6L, true, false, log);
        PsxLoader.createNamedWord(fpa, 528486512L, "I_STAT", log);
        PsxLoader.createNamedWord(fpa, 528486516L, "I_MASK", log);
    }

    private static void addDma(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "DMA_MDEC_IN", 528486528L, 12L, true, false, log);
        PsxLoader.createSegment(fpa, null, "DMA_MDEC_OUT", 528486544L, 12L, true, false, log);
        PsxLoader.createSegment(fpa, null, "DMA_GPU", 528486560L, 12L, true, false, log);
        PsxLoader.createSegment(fpa, null, "DMA_CDROM", 528486576L, 12L, true, false, log);
        PsxLoader.createSegment(fpa, null, "DMA_SPU", 528486592L, 12L, true, false, log);
        PsxLoader.createSegment(fpa, null, "DMA_PIO", 528486608L, 12L, true, false, log);
        PsxLoader.createSegment(fpa, null, "DMA_OTC", 528486624L, 12L, true, false, log);
        PsxLoader.createSegment(fpa, null, "DMA_CTRL_INT", 528486640L, 8L, true, false, log);
        PsxLoader.createNamedDword(fpa, 528486528L, "DMA_MDEC_IN_MADR", log);
        PsxLoader.createNamedDword(fpa, 528486532L, "DMA_MDEC_IN_BCR", log);
        PsxLoader.createNamedDword(fpa, 528486536L, "DMA_MDEC_IN_CHCR", log);
        PsxLoader.createNamedDword(fpa, 528486544L, "DMA_MDEC_OUT_MADR", log);
        PsxLoader.createNamedDword(fpa, 528486548L, "DMA_MDEC_OUT_BCR", log);
        PsxLoader.createNamedDword(fpa, 528486552L, "DMA_MDEC_OUT_CHCR", log);
        PsxLoader.createNamedDword(fpa, 528486560L, "DMA_GPU_MADR", log);
        PsxLoader.createNamedDword(fpa, 528486564L, "DMA_GPU_BCR", log);
        PsxLoader.createNamedDword(fpa, 528486568L, "DMA_GPU_CHCR", log);
        PsxLoader.createNamedDword(fpa, 528486576L, "DMA_CDROM_MADR", log);
        PsxLoader.createNamedDword(fpa, 528486580L, "DMA_CDROM_BCR", log);
        PsxLoader.createNamedDword(fpa, 528486584L, "DMA_CDROM_CHCR", log);
        PsxLoader.createNamedDword(fpa, 528486592L, "DMA_SPU_MADR", log);
        PsxLoader.createNamedDword(fpa, 528486596L, "DMA_SPU_BCR", log);
        PsxLoader.createNamedDword(fpa, 528486600L, "DMA_SPU_CHCR", log);
        PsxLoader.createNamedDword(fpa, 528486608L, "DMA_PIO_MADR", log);
        PsxLoader.createNamedDword(fpa, 528486612L, "DMA_PIO_BCR", log);
        PsxLoader.createNamedDword(fpa, 528486616L, "DMA_PIO_CHCR", log);
        PsxLoader.createNamedDword(fpa, 528486624L, "DMA_OTC_MADR", log);
        PsxLoader.createNamedDword(fpa, 528486628L, "DMA_OTC_BCR", log);
        PsxLoader.createNamedDword(fpa, 528486632L, "DMA_OTC_CHCR", log);
        PsxLoader.createNamedDword(fpa, 528486640L, "DMA_DPCR", log);
        PsxLoader.createNamedDword(fpa, 528486644L, "DMA_DICR", log);
    }

    private static void addTimers(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "TMR_DOTCLOCK", 528486656L, 16L, true, false, log);
        PsxLoader.createSegment(fpa, null, "TMR_HRETRACE", 528486672L, 16L, true, false, log);
        PsxLoader.createSegment(fpa, null, "TMR_SYSCLOCK", 528486688L, 16L, true, false, log);
        PsxLoader.createNamedDword(fpa, 528486656L, "TMR_DOTCLOCK_VAL", log);
        PsxLoader.createNamedDword(fpa, 528486660L, "TMR_DOTCLOCK_MODE", log);
        PsxLoader.createNamedDword(fpa, 528486664L, "TMR_DOTCLOCK_MAX", log);
        PsxLoader.createNamedDword(fpa, 528486672L, "TMR_HRETRACE_VAL", log);
        PsxLoader.createNamedDword(fpa, 528486676L, "TMR_HRETRACE_MODE", log);
        PsxLoader.createNamedDword(fpa, 528486680L, "TMR_HRETRACE_MAX", log);
        PsxLoader.createNamedDword(fpa, 528486688L, "TMR_SYSCLOCK_VAL", log);
        PsxLoader.createNamedDword(fpa, 528486692L, "TMR_SYSCLOCK_MODE", log);
        PsxLoader.createNamedDword(fpa, 528486696L, "TMR_SYSCLOCK_MAX", log);
    }

    private static void addCdromRegs(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "CDROM_REGS", 528488448L, 4L, true, false, log);
        PsxLoader.createNamedByte(fpa, 528488448L, "CDROM_REG0", log);
        PsxLoader.createNamedByte(fpa, 528488449L, "CDROM_REG1", log);
        PsxLoader.createNamedByte(fpa, 528488450L, "CDROM_REG2", log);
        PsxLoader.createNamedByte(fpa, 528488451L, "CDROM_REG3", log);
    }

    private static void addGpuRegs(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "GPU_REGS", 528488464L, 8L, true, false, log);
        PsxLoader.createNamedDword(fpa, 528488464L, "GPU_REG0", log);
        PsxLoader.createNamedDword(fpa, 528488468L, "GPU_REG1", log);
    }

    private static void addMdecRegs(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "MDEC_REGS", 528488480L, 8L, true, false, log);
        PsxLoader.createNamedDword(fpa, 528488480L, "MDEC_REG0", log);
        PsxLoader.createNamedDword(fpa, 528488484L, "MDEC_REG1", log);
    }

    private static void addSpuVoices(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "SPU_VOICES", 528489472L, 384L, true, false, log);
        for (int i = 0; i < 24; ++i) {
            PsxLoader.createNamedDword(fpa, 528489472L + (long)(i * 16), String.format("VOICE_%02x_LEFT_RIGHT", i), log);
            PsxLoader.createNamedWord(fpa, 528489472L + (long)(i * 16) + 4L, String.format("VOICE_%02x_ADPCM_SAMPLE_RATE", i), log);
            PsxLoader.createNamedWord(fpa, 528489472L + (long)(i * 16) + 6L, String.format("VOICE_%02x_ADPCM_START_ADDR", i), log);
            PsxLoader.createNamedWord(fpa, 528489472L + (long)(i * 16) + 8L, String.format("VOICE_%02x_ADSR_ATT_DEC_SUS_REL", i), log);
            PsxLoader.createNamedWord(fpa, 528489472L + (long)(i * 16) + 12L, String.format("VOICE_%02x_ADSR_CURR_VOLUME", i), log);
            PsxLoader.createNamedWord(fpa, 528489472L + (long)(i * 16) + 14L, String.format("VOICE_%02x_ADPCM_REPEAT_ADDR", i), log);
        }
    }

    private static void addSpuCtrlRegs(FlatProgramAPI fpa, MessageLog log) {
        PsxLoader.createSegment(fpa, null, "SPU_CTRL_REGS", 528489856L, 64L, true, false, log);
        PsxLoader.createNamedWord(fpa, 528489856L, "SPU_MAIN_VOL_L", log);
        PsxLoader.createNamedWord(fpa, 528489858L, "SPU_MAIN_VOL_R", log);
        PsxLoader.createNamedWord(fpa, 528489860L, "SPU_REVERB_OUT_L", log);
        PsxLoader.createNamedWord(fpa, 528489862L, "SPU_REVERB_OUT_R", log);
        PsxLoader.createNamedDword(fpa, 528489864L, "SPU_VOICE_KEY_ON", log);
        PsxLoader.createNamedDword(fpa, 528489868L, "SPU_VOICE_KEY_OFF", log);
        PsxLoader.createNamedDword(fpa, 528489872L, "SPU_VOICE_CHN_FM_MODE", log);
        PsxLoader.createNamedDword(fpa, 528489876L, "SPU_VOICE_CHN_NOISE_MODE", log);
        PsxLoader.createNamedDword(fpa, 528489880L, "SPU_VOICE_CHN_REVERB_MODE", log);
        PsxLoader.createNamedDword(fpa, 528489884L, "SPU_VOICE_CHN_ON_OFF_STATUS", log);
        PsxLoader.createNamedWord(fpa, 528489888L, "SPU_UNKN_1DA0", log);
        PsxLoader.createNamedWord(fpa, 528489890L, "SOUND_RAM_REVERB_WORK_ADDR", log);
        PsxLoader.createNamedWord(fpa, 528489892L, "SOUND_RAM_IRQ_ADDR", log);
        PsxLoader.createNamedWord(fpa, 528489894L, "SOUND_RAM_DATA_TRANSFER_ADDR", log);
        PsxLoader.createNamedWord(fpa, 528489896L, "SOUND_RAM_DATA_TRANSFER_FIFO", log);
        PsxLoader.createNamedWord(fpa, 528489898L, "SPU_CTRL_REG_CPUCNT", log);
        PsxLoader.createNamedWord(fpa, 528489900L, "SOUND_RAM_DATA_TRANSTER_CTRL", log);
        PsxLoader.createNamedWord(fpa, 528489902L, "SPU_STATUS_REG_SPUSTAT", log);
        PsxLoader.createNamedWord(fpa, 528489904L, "CD_VOL_L", log);
        PsxLoader.createNamedWord(fpa, 528489906L, "CD_VOL_R", log);
        PsxLoader.createNamedWord(fpa, 528489908L, "EXT_VOL_L", log);
        PsxLoader.createNamedWord(fpa, 528489910L, "EXT_VOL_R", log);
        PsxLoader.createNamedWord(fpa, 528489912L, "CURR_MAIN_VOL_L", log);
        PsxLoader.createNamedWord(fpa, 528489914L, "CURR_MAIN_VOL_R", log);
        PsxLoader.createNamedDword(fpa, 528489916L, "SPU_UNKN_1DBC", log);
    }

    private static void createNamedByte(FlatProgramAPI fpa, long address, String name, MessageLog log) {
        try {
            fpa.createByte(fpa.toAddr(address));
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
            return;
        }
        try {
            fpa.getCurrentProgram().getSymbolTable().createLabel(fpa.toAddr(address), name, SourceType.IMPORTED);
        }
        catch (InvalidInputException e) {
            log.appendException((Throwable)e);
        }
    }

    private static void createNamedWord(FlatProgramAPI fpa, long address, String name, MessageLog log) {
        try {
            fpa.createWord(fpa.toAddr(address));
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
            return;
        }
        try {
            fpa.getCurrentProgram().getSymbolTable().createLabel(fpa.toAddr(address), name, SourceType.IMPORTED);
        }
        catch (InvalidInputException e) {
            log.appendException((Throwable)e);
        }
    }

    private static void createNamedDword(FlatProgramAPI fpa, long address, String name, MessageLog log) {
        try {
            fpa.createDWord(fpa.toAddr(address));
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
            return;
        }
        try {
            fpa.getCurrentProgram().getSymbolTable().createLabel(fpa.toAddr(address), name, SourceType.IMPORTED);
        }
        catch (InvalidInputException e) {
            log.appendException((Throwable)e);
        }
    }

    private static void createSegment(FlatProgramAPI fpa, InputStream stream, String name, long address, long size, boolean write, boolean execute, MessageLog log) {
        try {
            MemoryBlock block = fpa.createMemoryBlock(name, fpa.toAddr(address), stream, size, false);
            block.setRead(true);
            block.setWrite(write);
            block.setExecute(execute);
        }
        catch (Exception e) {
            log.appendException((Throwable)e);
        }
    }
}

