/*
 * Decompiled with CFR 0.152.
 */
package psyq;

import ghidra.framework.Application;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import psx.PsxAnalyzer;
import psyq.MaskedBytes;
import psyq.PsyqSig;
import psyq.SigApplier;

public class DetectPsyQ {
    private static final byte[] VERSION_BYTES = new byte[]{80, 115, 7, 0, 0, 0, 71, 0};
    private static final byte[] VERSION_MASK = new byte[]{-1, -1, -32, 0, 0, 0, 0, -18};
    private static final long VERSION_OFFSET = 6L;
    private static final List<String> OLD_VERSIONS = Arrays.asList("260", "300", "330", "340", "350");
    private static final String OLD_UNIQUE_LIB = "LIBGPU.LIB";
    private static final String OLD_UNIQUE_OBJ = "SYS.OBJ";

    public static String getPsyqVersion(Memory mem, Address startAddress) throws MemoryAccessException, AddressOutOfBoundsException, FileNotFoundException, IOException {
        Address result = mem.findBytes(startAddress, VERSION_BYTES, VERSION_MASK, true, TaskMonitor.DUMMY);
        if (result == null) {
            return DetectPsyQ.getOldPsyqVersion(mem, startAddress);
        }
        short version = mem.getShort(result.add(6L), true);
        if ((version & 0xFF) == 0) {
            return String.format("%03X", version >> 4);
        }
        return String.format("%X", version);
    }

    private static String getOldPsyqVersion(Memory mem, Address startAddress) throws FileNotFoundException, IOException {
        File[] dirs;
        File psyqDir = Application.getModuleDataSubDirectory((String)"psyq").getFile(false);
        for (File verDir : dirs = psyqDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory() && OLD_VERSIONS.contains(name);
            }
        })) {
            String gameId = mem.getProgram().getName();
            String libJsonFile = new File(verDir, String.format("%s.json", OLD_UNIQUE_LIB)).getAbsolutePath();
            SigApplier sig = new SigApplier(gameId, libJsonFile, null, PsxAnalyzer.onlyFirst, PsxAnalyzer.minEntropy, TaskMonitor.DUMMY);
            List<PsyqSig> signatures = sig.getSignatures();
            for (PsyqSig item : signatures) {
                MaskedBytes bytes;
                Address result;
                if (!item.getName().equals(OLD_UNIQUE_OBJ) || (result = mem.findBytes(startAddress, (bytes = item.getSig()).getBytes(), bytes.getMasks(), true, TaskMonitor.DUMMY)) == null) continue;
                return verDir.getName();
            }
        }
        return "";
    }
}

