/*
 * Decompiled with CFR 0.152.
 */
package psyq;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import generic.stl.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import psyq.MaskedBytes;

public final class PsyqSig {
    private final String name;
    private final MaskedBytes sig;
    private final List<Pair<String, Integer>> labels;
    private boolean applied = false;
    private final float entropy;

    private PsyqSig(String name, MaskedBytes sig, List<Pair<String, Integer>> labels) {
        this.name = name;
        this.sig = sig;
        this.labels = labels;
        this.entropy = PsyqSig.calcEntropy(sig);
    }

    public float getEntropy() {
        return this.entropy;
    }

    public void setApplied(boolean applied) {
        this.applied = applied;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public String getName() {
        return this.name;
    }

    public MaskedBytes getSig() {
        return this.sig;
    }

    public List<Pair<String, Integer>> getLabels() {
        return this.labels;
    }

    public static PsyqSig fromJsonToken(JsonObject token, JsonArray patches) throws IOException {
        String name = token.get("name").getAsString();
        String sig = token.get("sig").getAsString();
        MaskedBytes signature = MaskedBytes.fromMaskedString(sig);
        ArrayList<Pair<String, Integer>> labels = new ArrayList<Pair<String, Integer>>();
        JsonArray arr = token.get("labels").getAsJsonArray();
        for (Object item : arr) {
            JsonObject itemObj = item.getAsJsonObject();
            String itemName = itemObj.get("name").getAsString();
            int itemOffset = itemObj.get("offset").getAsInt();
            labels.add((Pair<String, Integer>)new Pair((Object)itemName, (Object)itemOffset));
        }
        if (patches == null) {
            return new PsyqSig(name, signature, labels);
        }
        ArrayList<Pair<Integer, Pair<String, String>>> patchesList = new ArrayList<Pair<Integer, Pair<String, String>>>();
        for (JsonElement patch : patches) {
            JsonObject itemObj = patch.getAsJsonObject();
            String patchObjName = itemObj.get("name").getAsString();
            if (!name.equalsIgnoreCase(patchObjName)) continue;
            JsonArray posPatches = itemObj.getAsJsonArray("patches");
            for (JsonElement posPatch : posPatches) {
                JsonObject posPatchObj = posPatch.getAsJsonObject();
                int itemPos = posPatchObj.get("pos").getAsInt();
                String itemData = posPatchObj.get("data").getAsString();
                String itemCheckData = posPatchObj.has("check") ? posPatchObj.get("check").getAsString() : null;
                patchesList.add((Pair<Integer, Pair<String, String>>)new Pair((Object)itemPos, (Object)new Pair((Object)itemData, (Object)itemCheckData)));
            }
        }
        try {
            List<Pair<String, Integer>> newLabels = signature.applyPatches(patchesList, labels);
            return new PsyqSig(name, signature, newLabels);
        }
        catch (IOException e) {
            throw new IOException(String.format("OBJ: %s, %s", name, e.getMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static float calcEntropy(MaskedBytes bytes) {
        void var6_7;
        int[] counts = new int[256];
        float entropy = 0.0f;
        float total = bytes.getLength();
        byte[] f = bytes.getBytes();
        byte[] m = bytes.getMasks();
        boolean bl = false;
        while (var6_7 < m.length) {
            void v0 = var6_7;
            f[v0] = (byte)(f[v0] & m[var6_7]);
            ++var6_7;
        }
        for (byte b : f) {
            int n = b + 128;
            counts[n] = counts[n] + 1;
        }
        for (int c : counts) {
            if (c == 0) continue;
            float p = (float)c / total;
            entropy = (float)((double)entropy - (double)p * Math.log(p) / Math.log(2.0));
        }
        return entropy;
    }
}

