/*
 * Decompiled with CFR 0.152.
 */
package psyq.structs;

import psyq.structs.Symbol;

public final class Section
extends Symbol {
    private final int group;
    private final byte alignment;
    private byte[] bytes;
    private int patchOffset;
    public static final int importsSectionIndex = 0;
    public static final String importsSectionName = ".imps";

    public Section(int number, String name, int group, byte alignment) {
        super(number, name, 0L, 0L);
        this.group = group;
        this.alignment = alignment;
        this.bytes = null;
        this.patchOffset = 0;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public long getLength() {
        return this.bytes != null ? (long)this.bytes.length : 0L;
    }

    public void setBytes(byte[] bytes) {
        this.patchOffset = this.bytes != null ? this.bytes.length : 0;
        this.bytes = bytes;
    }

    public void doAlign() {
        if (this.bytes.length % this.alignment != 0) {
            byte[] newBytes = new byte[this.bytes.length + (this.alignment - this.bytes.length % this.alignment)];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
            this.bytes = newBytes;
        }
    }

    public int getPatchOffset() {
        return this.patchOffset;
    }

    public final int getGroup() {
        return this.group;
    }

    public final byte getAlignment() {
        return this.alignment;
    }
}

