/*
 * Decompiled with CFR 0.152.
 */
package psx;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class PsxExe
implements StructConverter {
    public static final int HEADER_SIZE = 2048;
    public static final String CODE_SEGM = "CODE";
    private static final String ASCII_ID = "PS-X EXE";
    private static final long ASCII_ID_OFF = 0L;
    private static final int ASCII_ID_LEN = 8;
    private static final long INIT_PC_OFF = 16L;
    private static final long INIT_GP_OFF = 20L;
    private static final long ROM_ADDR_OFF = 24L;
    private static final long ROM_SIZE_OFF = 28L;
    private static final long DATA_ADDR_OFF = 32L;
    private static final long DATA_SIZE_OFF = 36L;
    private static final long BSS_ADDR_OFF = 40L;
    private static final long BSS_SIZE_OFF = 44L;
    private static final long SP_BASE_OFF = 48L;
    private static final long SP_OFFSET_OFF = 52L;
    private long initPc = 0L;
    private long initGp = 0L;
    private long romAddr = 0L;
    private long romSize = 0L;
    private long dataAddr = 0L;
    private long dataSize = 0L;
    private long bssAddr = 0L;
    private long bssSize = 0L;
    private long spBase = 0L;
    private long spOff = 0L;
    private boolean parsed = false;

    public PsxExe(BinaryReader reader) throws IOException {
        this.Parse(reader);
    }

    private void Parse(BinaryReader reader) throws IOException {
        if (reader.length() < 2048L) {
            return;
        }
        String ascii_id = reader.readFixedLenAsciiString(0L, 8);
        if (!ascii_id.equals(ASCII_ID)) {
            return;
        }
        this.initPc = reader.readUnsignedInt(16L);
        this.initGp = reader.readUnsignedInt(20L);
        this.romAddr = reader.readUnsignedInt(24L);
        this.romSize = reader.readUnsignedInt(28L);
        this.dataAddr = reader.readUnsignedInt(32L);
        this.dataSize = reader.readUnsignedInt(36L);
        this.bssAddr = reader.readUnsignedInt(40L);
        this.bssSize = reader.readUnsignedInt(44L);
        this.spBase = reader.readUnsignedInt(48L);
        this.spOff = reader.readUnsignedInt(52L);
        this.parsed = true;
    }

    public long getRomStart() {
        return this.romAddr;
    }

    public long getRomSize() {
        return this.romSize;
    }

    public long getRomEnd() {
        return this.romAddr + this.romSize;
    }

    public long getDataAddr() {
        return this.dataAddr;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getBssAddr() {
        return this.bssAddr;
    }

    public long getBssSize() {
        return this.bssSize;
    }

    public long getSpBase() {
        return this.spBase;
    }

    public long getSpOff() {
        return this.spOff;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public long getInitPc() {
        return this.initPc;
    }

    public long getInitGp() {
        return this.initGp;
    }

    public DataType toDataType() {
        StructureDataType s = new StructureDataType("PsxHeader", 0);
        s.add(ASCII, 16, "ascii_id", null);
        s.add(POINTER, 4, "init_pc", null);
        s.add(POINTER, 4, "init_gp", null);
        s.add(POINTER, 4, "ram_addr", null);
        s.add(DWORD, 4, "ram_size", null);
        s.add(POINTER, 4, "data_addr", null);
        s.add(DWORD, 4, "data_size", null);
        s.add(POINTER, 4, "bss_addr", null);
        s.add(DWORD, 4, "bss_size", null);
        s.add(POINTER, 4, "sp_base", null);
        s.add(DWORD, 4, "sp_offs", null);
        s.add(ASCII, 20, "reserved_a", null);
        s.add(ASCII, 1972, "marker", null);
        return s;
    }
}

